# Version: 1.1.0
# Description: This script removes fonts from the EFI system partition to free up space. It also provides an option to remove additional files for HP computers or laptops.
# Author: Dani Luxenburger
# Author URL: https://luxenburger.nl | https://kb.luxenburger.nl
# Issues: info@luxenburger.nl
# Tags: EFI, System Partition, Fonts, Windows, PowerShell, Script
# Dependencies: PowerShell

# Refrences:
function Exit-Script {
    param (
        [string]$Message = "Exiting script...",
        [string]$Color = "Red"
    )
    waitfor.exe /t 10
    Write-Host $Message -ForegroundColor $Color
    Exit
}

# Run this script with administrative privileges
# Use extreme caution as it involves critical system partitions
$Proceed = Read-Host "Do you want to proceed with cleaning up the EFI system partition? (Yes/No)"
if ($Proceed -eq "Yes") {
    mountvol Y: /s
    Set-Location Y:/EFI/Microsoft/Boot/Fonts
    Remove-Item -Force -Recurse *.*
    write-host "Fonts removed successfully." -ForegroundColor Green
    # Check if the user has an HP computer or laptop
    $UserHasHP = Read-Host "Do you have an HP computer or laptop and need to clear more space? (Yes/No)"
    if ($UserHasHP -eq "Yes") {
        Set-Location Y:/EFI/HP/BiosUpdate
        Remove-Item -Force -Recurse *.*
        # Check if the user wants to delete more files
        $DeleteMoreFiles = Read-Host "Do you wish to make more space? (Yes/No)"
        if ($DeleteMoreFiles -eq "Yes") {
            Set-Location Y:/EFI/HP/DEVFW
            Remove-Item -Force -Recurse *.*
            waitfor.exe /t 10
            Write-Host "Script execution completed." -ForegroundColor Green
            Exit-Script
        } else {
            write-host "No further changes were made." -ForegroundColor Red
            Exit-Script
        }
    } else {
        write-host "Script completed" -ForegroundColor Red
        Exit-Script
    }
} else {
    write-host "Operation canceled. No changes were made." -ForegroundColor Red
    Exit-Script
}